dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 2, 160, 360, "assets/images/table/castle_2", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 5, 270, 485, "assets/images/table/castle_6", "assets/images/food/item_mark2", "B" );
LManager:AddNewTable( 3, 6, 310, 360, "assets/images/table/castle_6", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 4, 4, 270, 220, "assets/images/table/castle", "assets/images/food/item_mark5", "R" );

numServers = 1;

useFloAsServer = 0;

useWineTable = 1;
numMoodBoosts = 3;
maxCoupleHappiness = 500;

--Level 5.9

--Group 1
guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 7, 1000);

--Group 2
guest = LManager.GenGuest(female03);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table3;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = male03;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(8, 14, 40000);

--Group 3
guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 17, 80000);

--Group 4
guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table1;
guest.percentRequestMusic = 70;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 22, 120000);

--Group 5
guest = LManager.GenGuest(male03);
guest.matchType = male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
guest.percentRequestDrink = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = male03;
guest.percentRequestDrink = 60;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(23, 27, 160000);

--Group 6
guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(28, 28, 200000);

--Group 7
guest = LManager.GenGuest(female03);
guest.matchType = male03;
LManager:AddGuest(guest); 

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = table1;
guest.percentRequestMusic = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(29, 35, 220000);

--Group 8
guest = LManager.GenGuest(male03);
guest.matchType = male03;
guest.percentRequestDrink = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = male03;
guest.percentRequestMusic = 40;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(36, 40, 250000);

-- Group 9

guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(41, 42, 320000);

LManager:AdjustGuestTolerance(140);



LManager:SetLevelSetting ("bridesmaidsDelay", 100000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

LManager:SetLevelSetting ("speakerDelay", 150000);
LManager:SetLevelSetting ("speakerChance", 100);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 200000 );

LManager:SetLevelSetting ("cakeTipDelay", 60000);
LManager:SetLevelSetting ("cakeTipChance", 100);


LManager:AddReseatingRequestForGuest( 50000, male03 );
LManager:AddReseatingRequestForGuest( 100000, female03 );
LManager:AddReseatingRequestForGuest( 150000, male03 );
LManager:AddReseatingRequestForGuest( 180000, female03 );
LManager:AddReseatingRequestForGuest( 200000, male03 );
LManager:AddReseatingRequestForGuest( 250000, female03 );
LManager:AddReseatingRequestForGuest( 260000, male03 );

-- Set up the Level Settings
LManager:SetLevelNumber(5,9);
LManager:SetLevelScores(19000, 23000);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/Disco Dance 1.ogg","assets/audio/music/uptempo_2.ogg");
LManager:SetBackgroundImage("assets/images/bg_castle");
LManager:SetChairImage("assets/images/table/chair05");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );